#pragma once


#define STRC_SS_COMM_LINE_MAX				(300)
typedef struct SsCommStrcPart
{
	int nError; 
	unsigned int	uRetrys;
	unsigned int	uTimeouts;
	unsigned int	uLength;
	unsigned char	aVal[STRC_SS_COMM_LINE_MAX];
} SsCommStrcPart;

#define STRC_SS_COMM_BLOCK_MAX				(100)

typedef struct SsCommStrcRequest
{
	unsigned int	uCommand;
	unsigned int	uCount;
	SsCommStrcPart	aPart[STRC_SS_COMM_BLOCK_MAX];
} SsCommStrcRequest;

typedef struct SsCommStrcResponse
{
	unsigned int	uCommand;
	unsigned int	uCount;
	SsCommStrcPart	aPart[STRC_SS_COMM_BLOCK_MAX];
} SsCommStrcResponse;


#define SsCommError_NoError							(0)
#define SsCommError_ObjectNull						(9000)
#define SsCommError_InvalidParameter				(9001)
#define SsCommError_OutOfMemory						(9002)
#define SsCommError_InvalidLength					(9003)
#define SsCommError_Overflow						(9004)
#define SsCommError_InvalidSigns					(9005)
#define SsCommError_InvalidTag						(9006)
#define SsCommError_InvalidCrc						(9007)
#define SsCommError_InvalidCommand					(9008)
#define SsCommError_InvalidResponseData				(9009)
#define SsCommError_InvalidPrecision				(9010)
#define SsCommError_FailedDecode					(9011)
#define SsCommError_FailedEncode					(9012)
#define SsCommError_Unrecognized					(9013)
#define SsCommError_OutOfValidLength				(9014)
#define SsCommError_IncompleteData					(9015)
#define SsCommError_InvalidValueRange				(9016)
#define SsCommError_InvalidDeviceHandle				(9017)
#define SsCommError_DeviceOpenFailed				(9018)
#define SsCommError_DeviceCloseFailed				(9019)
#define SsCommError_DeviceWriteError				(9020)
#define SsCommError_DeviceReadError					(9021)
#define SsCommError_OpenFailedDeviceNotFound		(9022)
#define SsCommError_OpenFailedAccessDenied			(9023)
#define SsCommError_OpenFailedSignalTimeout			(9024)
#define SsCommError_SetupCommBuffers				(9025)
#define SsCommError_SetCommTimeouts					(9026)
#define SsCommError_GetCommState					(9027)
#define SsCommError_SetCommState					(9028)
#define SsCommError_PurgeComm						(9029)
#define SsCommError_ReadDataTimeout					(9030)
#define SsCommError_ReadDataError					(9031)
#define SsCommError_WriteDataTimeout				(9032)
#define SsCommError_WriteDataError					(9033)
#define SsCommError_LoadDbsFailed					(9034)
#define SsCommError_LoadObjectFailed				(9035)
#define SsCommError_LoadDbModelFailed				(9036)
#define SsCommError_BuildRequestFailed				(9037)
#define SsCommError_UnkownError						(9999)


#define SsCommEvent_DeviceOpenSucceed				(8000)
#define SsCommEvent_DeviceOpenFailed				(8001)

#define SsCommEvent_DeviceCloseSucceed				(8002)
#define SsCommEvent_DeviceCloseFailed				(8003)

#define SsCommEvent_DeviceConnectSucceed			(8004)
#define SsCommEvent_DeviceConnectFailed				(8005)

#define SsCommEvent_ProgrammerReadingSucceed		(8006)
#define SsCommEvent_ProgrammerReadSucceed			(8007)
#define SsCommEvent_ProgrammerReadFailed			(8008)
#define SsCommEvent_ProgrammerWritingSucceed		(8009)
#define SsCommEvent_ProgrammerWriteSucceed			(8010)
#define SsCommEvent_ProgrammerWriteFailed			(8011)

#define SsCommEvent_LedDriverReadingSucceed			(8012)
#define SsCommEvent_LedDriverReadSucceed			(8013)
#define SsCommEvent_LedDriverReadFailed				(8014)
#define SsCommEvent_LedDriverWritingSucceed			(8015)
#define SsCommEvent_LedDriverWriteSucceed			(8016)
#define SsCommEvent_LedDriverWriteFailed			(8017)

#define SsCommEvent_DecodeConnectSucceed			(8018)
#define SsCommEvent_DecodeConnectFailed				(8019)

#define SsCommEvent_DecodeProgrammerReadSucceed		(8020)
#define SsCommEvent_DecodeProgrammerReadFailed		(8021)
#define SsCommEvent_DecodeProgrammerWriteSucceed	(8022)
#define SsCommEvent_DecodeProgrammerWriteFailed		(8023)

#define SsCommEvent_DecodeLedDriverReadSucceed		(8024)
#define SsCommEvent_DecodeLedDriverReadFailed		(8025)
#define SsCommEvent_DecodeLedDriverWriteSucceed		(8026)
#define SsCommEvent_DecodeLedDriverWriteFailed		(8027)

#define SsCommEvent_Unkown							(8999)
